package EXT.DOMAIN.pit.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Hashtable;
import java.util.logging.Logger;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.logging.LoggingHelper;
import weblogic.rjvm.JVMID;

public class VeteranProcedure {

//	private static VeteranProcedure instance = null;	//vadim
	private final static Logger logger = LoggingHelper.getServerLogger();
	private Connection con = null;
	private CallableStatement cs = null;

//	private VeteranProcedure() {	//vadim
	public VeteranProcedure() {
		this.getDBConnection();
	}

//	public static VeteranProcedure getInstance() {	//vadim
//        if (instance == null) {
//        	instance = new VeteranProcedure();
//        }
//        return instance;
//    }

	private void getDBConnection() {
		String exceptionMessage = null;
		try {
			JVMID jvmid = JVMID.localID();
			String serverName = jvmid.getServerName();
		    String serverAddress = jvmid.getAddress();
		    InitialContext ctx = new InitialContext();
		    MBeanServer server = (MBeanServer) ctx.lookup("java:comp/env/jmx/runtime");
		    ObjectName objName = new ObjectName("com.bea:Name=" + serverName + ",Type=Server");
		    int port = (Integer) server.getAttribute(objName, "ListenPort");

			logger.fine("\nHost: " + serverAddress + "\nPort: " + port);

			Hashtable ht = new Hashtable();
			ht.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
			ht.put(Context.PROVIDER_URL, "t3://" + serverAddress + ":" + port);
        	ctx = new InitialContext(ht);
        	javax.sql.DataSource ds = (javax.sql.DataSource) ctx.lookup("jdbc/pitDataSource");
        	con = ds.getConnection();
        } catch (NamingException e) {
    		exceptionMessage = "NamingException caught in getDBConnection() method";
		} catch (AttributeNotFoundException e) {
			exceptionMessage = "AttributeNotFoundException caught in getDBConnection() method";
		} catch (InstanceNotFoundException e) {
			exceptionMessage = "InstanceNotFoundException caught in getDBConnection() method";
		} catch (MBeanException e) {
			exceptionMessage = "MBeanException caught in getDBConnection() method";
		} catch (ReflectionException e) {
			exceptionMessage = "ReflectionException caught in getDBConnection() method";
		} catch (MalformedObjectNameException e) {
			exceptionMessage = "MalformedObjectNameException caught in getDBConnection() method";
		} catch (SQLException e) {
			exceptionMessage = "SQLException caught in getDBConnection() method";
		} catch (Exception e) {
			exceptionMessage = "General exception caught in getDBConnection() method";
		} finally {
			if (exceptionMessage != null) {
				logger.severe(exceptionMessage);
				throw new RuntimeException(exceptionMessage);
			}
		}
	}

	public String callProcedure(String surveyRecordID, long surveyDateTime, String firstName, 
			String middleName, String lastName, String gender, int age, String deviceID, 
			boolean chronic, float loc_Latitude, float loc_Longitude, float loc_Accuracy, 
			String address, String city, String state) {
		String returnCode = null;
        try {
            cs = con.prepareCall("{call PIT.ap_PostSurveyRecord(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
            cs.setString("survey_id", surveyRecordID);
            cs.setTimestamp("survey_date", new Timestamp(surveyDateTime));
            cs.setString("first_name", firstName);
            cs.setString("middle_name", middleName);
            cs.setString("last_name", lastName);
            cs.setString("veteran_gender", gender);
            cs.setInt("veteran_age", age);
            cs.setString("device_id", deviceID);
            cs.setBoolean("chronically_homeless", chronic);
            cs.setFloat("location_latitude", loc_Latitude);
            cs.setFloat("location_longitude", loc_Longitude);
            cs.setFloat("location_accuracy", loc_Accuracy);
            cs.setString("location_address", address);
            cs.setString("location_city", city);
            cs.setString("location_state", state);
            cs.registerOutParameter("returncode", Types.VARCHAR);

            cs.execute();
            returnCode = cs.getString("returncode");
            if (returnCode != null) {
                logger.fine("\nReturnCode: " + returnCode);
            }
        } 
        catch (SQLException e) {
        	logger.severe("SQLException caught in callProcedure() method when executing CallableStatement");
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                } catch (SQLException e) {
                	logger.severe("SQLException caught in callProcedure() method when closing CallableStatement");
                }
            }
            if (con != null) {	//vadim
        		try {
					con.close();
				} catch (SQLException e) {
                	logger.severe("SQLException caught in callProcedure() method when closing DB connection");
				}
            }
        }
        String response;
        if (returnCode != null) {
        	response = returnCode.equals("0") ? "success" : returnCode;
        }
        else {
        	response = "The ReturnCode is empty.";
        }
        return response;
    }
}
